module.exports = {
    purge: [
        './resources/**/*.blade.php',
        './resources/**/*.js',
        './resources/**/*.vue',
    ],
    darkMode: 'class', // or 'media' or false
    theme: {
        extend: {
            colors: {
                primary: {
                    DEFAULT: '#5A8FDD',
                    50: '#EFF4FC',
                    100: '#DCE7F7',
                    200: '#B8D0EF',
                    300: '#94B8E7',
                    400: '#77A3E2',
                    500: '#5A8FDD',
                    600: '#3A77D4',
                    700: '#2862BC',
                    800: '#1F4D94',
                    900: '#16386C',
                },
                secondary: {
                    lavender: {
                        DEFAULT: '#BFA2DB',
                        light: '#D8C8EA',
                        dark: '#A67FC9',
                    },
                    mint: {
                        DEFAULT: '#A3D9B1',
                        light: '#C1E6CA',
                        dark: '#7FC495',
                    },
                },
                accent: {
                    coral: {
                        DEFAULT: '#F7B7A3',
                        light: '#FADACF',
                        dark: '#F39377',
                    },
                    yellow: {
                        DEFAULT: '#F9E79F',
                        light: '#FCF3CF',
                        dark: '#F6DB6F',
                    },
                },
                neutral: {
                    light: '#F2F2F2',
                    DEFAULT: '#9E9E9E',
                    dark: '#4A4A4A',
                },
            },
            fontFamily: {
                sans: ['Inter', 'sans-serif'],
            },
        },
    },
    variants: {
        extend: {
            opacity: ['disabled'],
            cursor: ['disabled'],
        },
    },
    plugins: [],
} 