import { createRouter, createWebHistory } from 'vue-router';

// Import page components
import Dashboard from './pages/Dashboard.vue';
import Login from './pages/Login.vue';
import Register from './pages/Register.vue';
import ContentCalendar from './pages/ContentCalendar.vue';
import Uploads from './pages/Uploads.vue';
import Comments from './pages/Comments.vue';
import Analytics from './pages/Analytics.vue';
import Settings from './pages/Settings.vue';
import NotFound from './pages/NotFound.vue';
import Linktree from './pages/Linktree.vue';
import LinktreePublic from './pages/LinktreePublic.vue';
import Earnings from './pages/Earnings.vue';

// Define routes
const routes = [
    {
        path: '/',
        name: 'dashboard',
        component: Dashboard,
        meta: { requiresAuth: true }
    },
    {
        path: '/login',
        name: 'login',
        component: Login,
        meta: { guest: true }
    },
    {
        path: '/register',
        name: 'register',
        component: Register,
        meta: { guest: true }
    },
    {
        path: '/calendar',
        name: 'calendar',
        component: ContentCalendar,
        meta: { requiresAuth: true }
    },
    {
        path: '/uploads',
        name: 'uploads',
        component: Uploads,
        meta: { requiresAuth: true }
    },
    {
        path: '/comments',
        name: 'comments',
        component: Comments,
        meta: { requiresAuth: true }
    },
    {
        path: '/analytics',
        name: 'analytics',
        component: Analytics,
        meta: { requiresAuth: true }
    },
    {
        path: '/earnings',
        name: 'earnings',
        component: Earnings,
        meta: { requiresAuth: true }
    },
    {
        path: '/settings',
        name: 'settings',
        component: Settings,
        meta: { requiresAuth: true }
    },
    {
        path: '/linktree',
        name: 'linktree',
        component: Linktree,
        meta: { requiresAuth: true }
    },
    {
        path: '/u/:username',
        name: 'linktree-public',
        component: LinktreePublic,
        meta: { public: true }
    },
    {
        path: '/:pathMatch(.*)*',
        name: 'not-found',
        component: NotFound
    }
];

const router = createRouter({
    history: createWebHistory(),
    routes,
    linkActiveClass: 'active'
});

// Navigation guards
router.beforeEach((to, from, next) => {
    // Check if the route requires authentication
    if (to.matched.some(record => record.meta.requiresAuth)) {
        // Check if user is authenticated
        const token = localStorage.getItem('token');
        if (!token) {
            // Not authenticated, redirect to login
            next({ name: 'login' });
        } else {
            // Authenticated, proceed
            next();
        }
    } else if (to.matched.some(record => record.meta.guest)) {
        // Check if route is for guests only
        const token = localStorage.getItem('token');
        if (token) {
            // Authenticated, redirect to dashboard
            next({ name: 'dashboard' });
        } else {
            // Not authenticated, proceed
            next();
        }
    } else {
        // No auth requirements, proceed
        next();
    }
});

export default router; 