export default {
  // General
  app: {
    title: 'ASMR Content Planner',
    subtitle: 'Your platform for ASMR content management',
    loading: 'Loading...'
  },
  
  // Navigation
  nav: {
    dashboard: 'Dashboard',
    calendar: 'Calendar',
    comments: 'Comments',
    analytics: 'Analytics',
    earnings: 'Earnings',
    linktree: 'Linktree',
    settings: 'Settings',
    signOut: 'Sign out',
    openUserMenu: 'Open user menu',
    closeUserMenu: 'Close user menu',
    toggleMobileMenu: 'Toggle mobile menu'
  },
  
  // Authentication
  auth: {
    login: 'Login',
    register: 'Register',
    email: 'Email address',
    password: 'Password',
    confirmPassword: 'Confirm password',
    fullName: 'Full name',
    rememberMe: 'Remember me',
    forgotPassword: 'Forgot password?',
    noAccount: 'Don\'t have an account?',
    alreadyRegistered: 'Already registered?',
    createAccount: 'Create account',
    createAccountSubtitle: 'Create your ASMR Content Planner account',
    loginSubtitle: 'Sign in to manage your ASMR content',
    passwordMismatch: 'Passwords do not match',
    loggingIn: 'Logging in...',
    registering: 'Registering...'
  },
  
  // Dashboard
  dashboard: {
    title: 'Dashboard',
    newUpload: 'New Upload',
    totalUploads: 'Total Uploads',
    viewAllUploads: 'View all uploads',
    newComments: 'New Comments',
    viewAllComments: 'View all comments',
    totalEarnings: 'Total Earnings',
    viewEarningsDetails: 'View earnings details',
    upcomingUploads: 'Upcoming Uploads',
    noUpcomingUploads: 'No upcoming uploads scheduled.',
    recentComments: 'Recent Comments',
    noRecentComments: 'No recent comments.',
    anonymousUser: 'Anonymous User',
    on: 'on',
    status: {
      scheduled: 'Scheduled',
      uploaded: 'Uploaded',
      failed: 'Failed'
    }
  },
  
  // Comments
  comments: {
    title: 'Comments Management',
    allPlatforms: 'All Platforms',
    refresh: 'Refresh',
    noCommentsFound: 'No comments found.',
    anonymousUser: 'Anonymous User',
    on: 'On',
    reply: 'Reply',
    delete: 'Delete',
    addYourReply: 'Add your reply...',
    cancel: 'Cancel',
    you: 'You',
    previous: 'Previous',
    next: 'Next',
    showing: 'Showing',
    to: 'to',
    of: 'of',
    results: 'results'
  },
  
  // Calendar
  calendar: {
    title: 'Content Calendar',
    scheduleUpload: 'Schedule Upload',
    month: 'Month',
    week: 'Week',
    day: 'Day',
    today: 'Today',
    days: {
      sun: 'Sun',
      mon: 'Mon',
      tue: 'Tue',
      wed: 'Wed',
      thu: 'Thu',
      fri: 'Fri',
      sat: 'Sat'
    },
    newUpload: {
      title: 'Schedule New Upload',
      videoTitle: 'Title',
      platform: 'Platform',
      selectPlatform: 'Select platform',
      uploadDate: 'Upload Date',
      description: 'Description',
      videoDescription: 'Video description',
      hashtags: 'Hashtags',
      schedule: 'Schedule',
      cancel: 'Cancel'
    },
    eventDetails: {
      edit: 'Edit',
      close: 'Close',
      description: 'Description',
      hashtags: 'Hashtags',
      status: {
        scheduled: 'Scheduled',
        uploaded: 'Uploaded',
        failed: 'Failed'
      }
    }
  },
  
  // Linktree
  linktree: {
    title: 'My Links',
    publicTitle: 'Links from',
    manage: 'Manage Links',
    view: 'View Public Page',
    addLink: 'Add New Link',
    editLink: 'Edit Link',
    deleteLink: 'Delete Link',
    noLinks: 'No links available. Add your first link!',
    categories: {
      social: 'Social Media',
      donation: 'Donations',
      affiliate: 'Affiliate',
      wishlist: 'Wishlist'
    },
    form: {
      title: 'Title',
      titlePlaceholder: 'e.g. My TikTok',
      url: 'URL',
      urlPlaceholder: 'https://...',
      category: 'Category',
      selectCategory: 'Select category',
      affiliateUrl: 'Affiliate URL (optional)',
      affiliateUrlPlaceholder: 'https://...',
      save: 'Save',
      cancel: 'Cancel'
    },
    wishlist: {
      addItem: 'Add Product',
      editItem: 'Edit Product',
      deleteItem: 'Delete Product',
      noItems: 'No products in wishlist. Add your first product!',
      form: {
        name: 'Product Name',
        namePlaceholder: 'e.g. ASMR Microphone',
        url: 'Product URL',
        urlPlaceholder: 'https://...',
        price: 'Price (optional)',
        currency: 'Currency',
        save: 'Save',
        cancel: 'Cancel'
      },
      buyNow: 'Buy Now'
    },
    dragAndDrop: 'Drag and drop links to change order',
    deleteConfirm: 'Are you sure you want to delete this link?',
    deleteItemConfirm: 'Are you sure you want to delete this product?',
    copyLink: 'Copy Link',
    linkCopied: 'Link copied to clipboard!',
    shareProfile: 'Share Profile'
  },
  
  // Languages
  languages: {
    de: 'German',
    en: 'English',
    ru: 'Russian',
    selectLanguage: 'Select language'
  },
  
  earnings: {
    title: 'Earnings',
    totalEarnings: 'Total Earnings',
    thisMonth: 'This Month',
    bestPlatform: 'Best Platform',
    comparedToLastMonth: 'compared to last month',
    daysLeft: 'days left',
    monthlyEarnings: 'Monthly Earnings',
    platformDistribution: 'Platform Distribution',
    platformComparison: 'Platform Comparison',
    earningsHistory: 'Earnings History',
    filterByPlatform: 'Filter by Platform',
    allPlatforms: 'All Platforms',
    date: 'Date',
    platform: 'Platform',
    amount: 'Amount',
    change: 'Change',
    showing: 'Showing',
    to: 'to',
    of: 'of',
    results: 'results',
    previous: 'Previous',
    next: 'Next',
    categories: {
      social: 'Social Media',
      donation: 'Donations',
      affiliate: 'Affiliate',
      wishlist: 'Wishlists'
    }
  }
}; 