export default {
  // Allgemein
  app: {
    title: 'ASMR Content Planner',
    subtitle: 'Ihre Plattform für ASMR-Content-Management',
    loading: 'Wird geladen...'
  },
  
  // Navigation
  nav: {
    dashboard: 'Dashboard',
    calendar: 'Kalender',
    comments: 'Kommentare',
    analytics: 'Analysen',
    earnings: 'Einnahmen',
    linktree: 'Linktree',
    settings: 'Einstellungen',
    signOut: 'Abmelden',
    openUserMenu: 'Benutzermenü öffnen',
    closeUserMenu: 'Benutzermenü schließen',
    toggleMobileMenu: 'Mobilmenü umschalten',
    openMenu: 'Menü öffnen'
  },
  
  // Authentifizierung
  auth: {
    login: 'Anmelden',
    register: 'Registrieren',
    email: 'E-Mail-Adresse',
    password: 'Passwort',
    confirmPassword: 'Passwort bestätigen',
    fullName: 'Vollständiger Name',
    rememberMe: 'Angemeldet bleiben',
    forgotPassword: 'Passwort vergessen?',
    noAccount: 'Noch kein Konto?',
    alreadyRegistered: 'Bereits registriert?',
    createAccount: 'Konto erstellen',
    createAccountSubtitle: 'Erstellen Sie Ihr ASMR Content Planner-Konto',
    loginSubtitle: 'Melden Sie sich an, um Ihre ASMR-Inhalte zu verwalten',
    passwordMismatch: 'Die Passwörter stimmen nicht überein',
    loggingIn: 'Anmeldung läuft...',
    registering: 'Registrierung läuft...'
  },
  
  // Dashboard
  dashboard: {
    title: 'Dashboard',
    newUpload: 'Neuer Upload',
    totalUploads: 'Gesamte Uploads',
    newComments: 'Neue Kommentare',
    totalViews: 'Gesamte Aufrufe',
    monthlyEarnings: 'Monatliche Einnahmen',
    viewAllUploads: 'Alle Uploads anzeigen',
    viewAllComments: 'Alle Kommentare anzeigen',
    viewAnalytics: 'Analysen anzeigen',
    viewEarnings: 'Einnahmen anzeigen',
    upcomingUploads: 'Anstehende Uploads',
    recentComments: 'Neueste Kommentare',
    noUpcomingUploads: 'Keine anstehenden Uploads',
    noRecentComments: 'Keine neuesten Kommentare',
    viewAll: 'Alle anzeigen',
    totalEarnings: 'Gesamteinnahmen',
    viewEarningsDetails: 'Einnahmendetails anzeigen',
    anonymousUser: 'Anonymer Benutzer',
    on: 'auf',
    status: {
      scheduled: 'Geplant',
      uploaded: 'Hochgeladen',
      failed: 'Fehlgeschlagen'
    }
  },
  
  // Kommentare
  comments: {
    title: 'Kommentarverwaltung',
    allPlatforms: 'Alle Plattformen',
    refresh: 'Aktualisieren',
    noCommentsFound: 'Keine Kommentare gefunden.',
    anonymousUser: 'Anonymer Benutzer',
    on: 'Auf',
    reply: 'Antworten',
    delete: 'Löschen',
    addYourReply: 'Fügen Sie Ihre Antwort hinzu...',
    cancel: 'Abbrechen',
    you: 'Sie',
    previous: 'Zurück',
    next: 'Weiter',
    showing: 'Zeige',
    to: 'bis',
    of: 'von',
    results: 'Ergebnissen'
  },
  
  // Kalender
  calendar: {
    title: 'Content-Kalender',
    scheduleUpload: 'Upload planen',
    month: 'Monat',
    week: 'Woche',
    day: 'Tag',
    today: 'Heute',
    days: {
      sun: 'So',
      mon: 'Mo',
      tue: 'Di',
      wed: 'Mi',
      thu: 'Do',
      fri: 'Fr',
      sat: 'Sa'
    },
    newUpload: {
      title: 'Neuen Upload planen',
      videoTitle: 'Titel',
      platform: 'Plattform',
      selectPlatform: 'Plattform auswählen',
      uploadDate: 'Upload-Datum',
      description: 'Beschreibung',
      videoDescription: 'Video-Beschreibung',
      hashtags: 'Hashtags',
      schedule: 'Planen',
      cancel: 'Abbrechen'
    },
    eventDetails: {
      edit: 'Bearbeiten',
      close: 'Schließen',
      description: 'Beschreibung',
      hashtags: 'Hashtags',
      status: {
        scheduled: 'Geplant',
        uploaded: 'Hochgeladen',
        failed: 'Fehlgeschlagen'
      }
    }
  },
  
  // Linktree
  linktree: {
    title: 'Meine Links',
    publicTitle: 'Links von',
    manage: 'Links verwalten',
    view: 'Öffentliche Seite anzeigen',
    addLink: 'Neuen Link hinzufügen',
    editLink: 'Link bearbeiten',
    deleteLink: 'Link löschen',
    noLinks: 'Keine Links vorhanden. Fügen Sie Ihren ersten Link hinzu!',
    categories: {
      social: 'Soziale Medien',
      donation: 'Spenden',
      affiliate: 'Affiliate',
      wishlist: 'Wunschliste'
    },
    form: {
      title: 'Titel',
      titlePlaceholder: 'z.B. Mein TikTok',
      url: 'URL',
      urlPlaceholder: 'https://...',
      category: 'Kategorie',
      selectCategory: 'Kategorie auswählen',
      affiliateUrl: 'Affiliate URL (optional)',
      affiliateUrlPlaceholder: 'https://...',
      save: 'Speichern',
      cancel: 'Abbrechen'
    },
    wishlist: {
      addItem: 'Produkt hinzufügen',
      editItem: 'Produkt bearbeiten',
      deleteItem: 'Produkt löschen',
      noItems: 'Keine Produkte in der Wunschliste. Fügen Sie Ihr erstes Produkt hinzu!',
      form: {
        name: 'Produktname',
        namePlaceholder: 'z.B. ASMR Mikrofon',
        url: 'Produkt-URL',
        urlPlaceholder: 'https://...',
        price: 'Preis (optional)',
        currency: 'Währung',
        save: 'Speichern',
        cancel: 'Abbrechen'
      },
      buyNow: 'Jetzt kaufen'
    },
    dragAndDrop: 'Ziehen Sie die Links, um die Reihenfolge zu ändern',
    deleteConfirm: 'Sind Sie sicher, dass Sie diesen Link löschen möchten?',
    deleteItemConfirm: 'Sind Sie sicher, dass Sie dieses Produkt löschen möchten?',
    copyLink: 'Link kopieren',
    linkCopied: 'Link in die Zwischenablage kopiert!',
    shareProfile: 'Profil teilen'
  },
  
  // Sprachen
  languages: {
    de: 'Deutsch',
    en: 'Englisch',
    ru: 'Russisch',
    selectLanguage: 'Sprache auswählen'
  },
  
  earnings: {
    title: 'Einnahmen',
    totalEarnings: 'Gesamteinnahmen',
    thisMonth: 'Dieser Monat',
    bestPlatform: 'Beste Plattform',
    comparedToLastMonth: 'im Vergleich zum Vormonat',
    daysLeft: 'Tage verbleibend',
    monthlyEarnings: 'Monatliche Einnahmen',
    platformDistribution: 'Plattformverteilung',
    platformComparison: 'Plattformvergleich',
    earningsHistory: 'Einnahmenhistorie',
    filterByPlatform: 'Nach Plattform filtern',
    allPlatforms: 'Alle Plattformen',
    date: 'Datum',
    platform: 'Plattform',
    amount: 'Betrag',
    change: 'Änderung',
    showing: 'Zeige',
    to: 'bis',
    of: 'von',
    results: 'Ergebnissen',
    previous: 'Zurück',
    next: 'Weiter',
    categories: {
      social: 'Social Media',
      donation: 'Spenden',
      affiliate: 'Affiliate',
      wishlist: 'Wunschlisten'
    }
  }
}; 