import { createI18n } from 'vue-i18n';
import de from './locales/de.js';
import en from './locales/en.js';
import ru from './locales/ru.js';

// Standardsprache aus dem Browser oder localStorage ermitteln
const getBrowserLanguage = () => {
  // Zuerst prüfen, ob eine Sprache im localStorage gespeichert ist
  const savedLanguage = localStorage.getItem('asmr-planner-language');
  if (savedLanguage && ['de', 'en', 'ru'].includes(savedLanguage)) {
    return savedLanguage;
  }
  
  // Ansonsten die Browsersprache verwenden
  const browserLang = navigator.language || navigator.userLanguage;
  const lang = browserLang.split('-')[0];
  
  // Prüfen, ob die Browsersprache unterstützt wird
  if (['de', 'en', 'ru'].includes(lang)) {
    return lang;
  }
  
  // Standardmäßig Englisch zurückgeben
  return 'en';
};

const i18n = createI18n({
  legacy: false, // Sie können dies auf true setzen, wenn Sie die Composition API nicht verwenden
  locale: getBrowserLanguage(),
  fallbackLocale: 'en',
  messages: {
    de,
    en,
    ru
  }
});

export default i18n;

// Hilfsfunktion zum Ändern der Sprache
export const setLanguage = (lang) => {
  if (['de', 'en', 'ru'].includes(lang)) {
    i18n.global.locale.value = lang;
    localStorage.setItem('asmr-planner-language', lang);
    document.documentElement.setAttribute('lang', lang);
  }
}; 