<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WishlistItem extends Model
{
    use HasFactory;
    
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'user_link_id',
        'item_name',
        'item_url',
        'price',
        'currency',
    ];
    
    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'price' => 'decimal:2',
    ];
    
    /**
     * Get the user link that owns the wishlist item.
     */
    public function userLink()
    {
        return $this->belongsTo(UserLink::class);
    }
} 