<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Auth;

class UserController extends Controller
{
    /**
     * Get the authenticated user
     */
    public function getAuthUser()
    {
        return response()->json(Auth::user());
    }
    
    /**
     * Get a user by username
     */
    public function getUserByUsername($username)
    {
        $user = User::where('username', $username)
            ->orWhere('name', 'LIKE', str_replace('-', '%', $username))
            ->firstOrFail();
            
        return response()->json([
            'id' => $user->id,
            'name' => $user->name,
            'username' => $user->username ?? strtolower(str_replace(' ', '-', $user->name)),
            'bio' => $user->bio ?? null,
            'avatar' => $user->avatar ?? null,
        ]);
    }
} 